﻿//////////////////////////////////////////////
// RendererAbstractData.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT RendererAbstractData final
	{
		public :

			// Constructor, destructor
			RendererAbstractData () noexcept ;
			~RendererAbstractData () ;

			// Getters
			void* get (nkMemory::StringView key) const ;

			// Setters
			void set (nkMemory::StringView key, void* value) ;

		private :

			// Attributes
			nkMemory::BufferCast<nkMemory::String> _keys ;
			nkMemory::BufferCast<void*> _values ;
	} ;
}